#ifndef CUFFTDX_FFT_2401_FP64_FWD_PTX_HPP
#define CUFFTDX_FFT_2401_FP64_FWD_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<551, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<27>;
.reg .f64 fd<639>;
.reg .b64 rd<17>;
mov.u32 r1, %tid.y;
mov.u32 r2, %14;
mad.lo.s32 r3, r1, 38416, r2;
mov.u32 r4, %tid.x;
add.f64 fd29, %20, %34;
add.f64 fd30, %18, fd29;
add.f64 fd31, %23, %31;
add.f64 fd32, fd31, fd30;
add.f64 fd33, %26, %28;
add.f64 fd34, %22, %35;
add.f64 fd35, %19, fd34;
add.f64 fd36, %25, %33;
add.f64 fd37, fd36, fd35;
add.f64 fd38, %27, %30;
fma.rn.f64 fd39, fd29, 0d3FE3F3A0E28BEDD1, %18;
mul.f64 fd40, fd31, 0d3FCC7B90E3024582;
sub.f64 fd41, fd39, fd40;
mul.f64 fd42, fd33, 0d3FECD4BCA9CB5C71;
sub.f64 fd43, fd41, fd42;
sub.f64 fd44, %22, %35;
mul.f64 fd45, fd44, 0d3FE904C37505DE4B;
sub.f64 fd46, %25, %33;
mul.f64 fd47, fd46, 0dBFEF329C0558E969;
sub.f64 fd48, fd47, fd45;
sub.f64 fd49, %27, %30;
mul.f64 fd50, fd49, 0d3FDBC4C04D71ABC1;
sub.f64 fd51, fd48, fd50;
sub.f64 fd52, fd43, fd51;
add.f64 fd53, fd51, fd43;
mul.f64 fd54, fd29, 0d3FCC7B90E3024582;
sub.f64 fd55, %18, fd54;
mul.f64 fd56, fd31, 0d3FECD4BCA9CB5C71;
sub.f64 fd57, fd55, fd56;
fma.rn.f64 fd58, fd33, 0d3FE3F3A0E28BEDD1, fd57;
mul.f64 fd59, fd44, 0d3FEF329C0558E969;
mul.f64 fd60, fd46, 0d3FDBC4C04D71ABC1;
sub.f64 fd61, fd60, fd59;
fma.rn.f64 fd62, fd49, 0d3FE904C37505DE4B, fd61;
sub.f64 fd63, fd58, fd62;
add.f64 fd64, fd62, fd58;
mul.f64 fd65, fd29, 0d3FECD4BCA9CB5C71;
sub.f64 fd66, %18, fd65;
fma.rn.f64 fd67, fd31, 0d3FE3F3A0E28BEDD1, fd66;
mul.f64 fd68, fd33, 0d3FCC7B90E3024582;
sub.f64 fd69, fd67, fd68;
mul.f64 fd70, fd44, 0d3FDBC4C04D71ABC1;
mul.f64 fd71, fd46, 0d3FE904C37505DE4B;
sub.f64 fd72, fd71, fd70;
mul.f64 fd73, fd49, 0d3FEF329C0558E969;
sub.f64 fd74, fd72, fd73;
sub.f64 fd75, fd69, fd74;
add.f64 fd76, fd74, fd69;
fma.rn.f64 fd77, fd34, 0d3FE3F3A0E28BEDD1, %19;
mul.f64 fd78, fd36, 0d3FCC7B90E3024582;
sub.f64 fd79, fd77, fd78;
mul.f64 fd80, fd38, 0d3FECD4BCA9CB5C71;
sub.f64 fd81, fd79, fd80;
sub.f64 fd82, %20, %34;
mul.f64 fd83, fd82, 0d3FE904C37505DE4B;
sub.f64 fd84, %23, %31;
mul.f64 fd85, fd84, 0dBFEF329C0558E969;
sub.f64 fd86, fd85, fd83;
sub.f64 fd87, %26, %28;
mul.f64 fd88, fd87, 0d3FDBC4C04D71ABC1;
sub.f64 fd89, fd86, fd88;
add.f64 fd90, fd89, fd81;
sub.f64 fd91, fd81, fd89;
mul.f64 fd92, fd34, 0d3FCC7B90E3024582;
sub.f64 fd93, %19, fd92;
mul.f64 fd94, fd36, 0d3FECD4BCA9CB5C71;
sub.f64 fd95, fd93, fd94;
fma.rn.f64 fd96, fd38, 0d3FE3F3A0E28BEDD1, fd95;
mul.f64 fd97, fd82, 0d3FEF329C0558E969;
mul.f64 fd98, fd84, 0d3FDBC4C04D71ABC1;
sub.f64 fd99, fd98, fd97;
fma.rn.f64 fd100, fd87, 0d3FE904C37505DE4B, fd99;
add.f64 fd101, fd100, fd96;
sub.f64 fd102, fd96, fd100;
mul.f64 fd103, fd34, 0d3FECD4BCA9CB5C71;
sub.f64 fd104, %19, fd103;
fma.rn.f64 fd105, fd36, 0d3FE3F3A0E28BEDD1, fd104;
mul.f64 fd106, fd38, 0d3FCC7B90E3024582;
sub.f64 fd107, fd105, fd106;
mul.f64 fd108, fd82, 0d3FDBC4C04D71ABC1;
mul.f64 fd109, fd84, 0d3FE904C37505DE4B;
sub.f64 fd110, fd109, fd108;
mul.f64 fd111, fd87, 0d3FEF329C0558E969;
sub.f64 fd112, fd110, fd111;
add.f64 fd113, fd112, fd107;
sub.f64 fd114, fd107, fd112;
mul.wide.u32 rd2, r4, -1089394037;
shr.u64 rd3, rd2, 40;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 343;
sub.s32 r7, r4, r6;
mad.lo.s32 r8, r5, 38416, r3;
mul.wide.u32 rd4, r7, 16;
mov.u64 rd5, %15;
add.s64 rd6, rd5, rd4;
ld.global.v2.f64 {fd115, fd116}, [rd6];
mul.f64 fd119, fd115, fd52;
mul.f64 fd120, fd116, fd90;
mul.f64 fd121, fd115, fd90;
mul.f64 fd122, fd115, fd115;
mul.f64 fd123, fd116, fd116;
sub.f64 fd124, fd122, fd123;
mul.f64 fd125, fd116, fd115;
fma.rn.f64 fd126, fd116, fd115, fd125;
mul.f64 fd127, fd124, fd63;
mul.f64 fd128, fd126, fd101;
mul.f64 fd129, fd124, fd101;
mul.f64 fd130, fd115, fd124;
mul.f64 fd131, fd116, fd126;
sub.f64 fd132, fd130, fd131;
mul.f64 fd133, fd115, fd126;
fma.rn.f64 fd134, fd116, fd124, fd133;
mul.f64 fd135, fd132, fd75;
mul.f64 fd136, fd134, fd113;
mul.f64 fd137, fd132, fd113;
ld.global.v2.f64 {fd138, fd139}, [rd6+5488];
mul.f64 fd142, fd138, fd76;
mul.f64 fd143, fd139, fd114;
mul.f64 fd144, fd138, fd114;
mul.f64 fd145, fd115, fd138;
mul.f64 fd146, fd116, fd139;
sub.f64 fd147, fd145, fd146;
mul.f64 fd148, fd115, fd139;
fma.rn.f64 fd149, fd116, fd138, fd148;
mul.f64 fd150, fd147, fd64;
mul.f64 fd151, fd149, fd102;
mul.f64 fd152, fd147, fd102;
mul.f64 fd153, fd115, fd147;
mul.f64 fd154, fd116, fd149;
sub.f64 fd155, fd153, fd154;
mul.f64 fd156, fd115, fd149;
fma.rn.f64 fd157, fd116, fd147, fd156;
mul.f64 fd158, fd155, fd53;
mul.f64 fd159, fd157, fd91;
mul.f64 fd160, fd155, fd91;
barrier.sync 0;
mad.lo.s32 r9, r7, 112, r8;
add.f64 fd161, fd38, fd37;
add.f64 fd162, fd33, fd32;
st.shared.v2.f64 [r9], {fd162, fd161};
fma.rn.f64 fd163, fd116, fd52, fd121;
sub.f64 fd164, fd119, fd120;
st.shared.v2.f64 [r9+16], {fd164, fd163};
fma.rn.f64 fd165, fd126, fd63, fd129;
sub.f64 fd166, fd127, fd128;
st.shared.v2.f64 [r9+32], {fd166, fd165};
sub.f64 fd167, fd135, fd136;
fma.rn.f64 fd168, fd134, fd75, fd137;
st.shared.v2.f64 [r9+48], {fd167, fd168};
fma.rn.f64 fd169, fd139, fd76, fd144;
sub.f64 fd170, fd142, fd143;
st.shared.v2.f64 [r9+64], {fd170, fd169};
fma.rn.f64 fd171, fd149, fd64, fd152;
sub.f64 fd172, fd150, fd151;
st.shared.v2.f64 [r9+80], {fd172, fd171};
sub.f64 fd173, fd158, fd159;
fma.rn.f64 fd174, fd157, fd53, fd160;
st.shared.v2.f64 [r9+96], {fd173, fd174};
barrier.sync 0;
mad.lo.s32 r10, r7, -96, r9;
ld.shared.v2.f64 {fd175, fd176}, [r10];
ld.shared.v2.f64 {fd179, fd180}, [r10+5488];
ld.shared.v2.f64 {fd183, fd184}, [r10+10976];
ld.shared.v2.f64 {fd187, fd188}, [r10+16464];
ld.shared.v2.f64 {fd191, fd192}, [r10+21952];
ld.shared.v2.f64 {fd195, fd196}, [r10+27440];
ld.shared.v2.f64 {fd199, fd200}, [r10+32928];
add.f64 fd203, fd179, fd199;
add.f64 fd204, fd175, fd203;
add.f64 fd205, fd183, fd195;
add.f64 fd206, fd205, fd204;
add.f64 fd207, fd187, fd191;
add.f64 fd208, fd180, fd200;
add.f64 fd209, fd176, fd208;
add.f64 fd210, fd184, fd196;
add.f64 fd211, fd210, fd209;
add.f64 fd212, fd188, fd192;
fma.rn.f64 fd213, fd203, 0d3FE3F3A0E28BEDD1, fd175;
mul.f64 fd214, fd205, 0d3FCC7B90E3024582;
sub.f64 fd215, fd213, fd214;
mul.f64 fd216, fd207, 0d3FECD4BCA9CB5C71;
sub.f64 fd217, fd215, fd216;
sub.f64 fd218, fd180, fd200;
mul.f64 fd219, fd218, 0d3FE904C37505DE4B;
sub.f64 fd220, fd184, fd196;
mul.f64 fd221, fd220, 0dBFEF329C0558E969;
sub.f64 fd222, fd221, fd219;
sub.f64 fd223, fd188, fd192;
mul.f64 fd224, fd223, 0d3FDBC4C04D71ABC1;
sub.f64 fd225, fd222, fd224;
sub.f64 fd226, fd217, fd225;
add.f64 fd227, fd225, fd217;
mul.f64 fd228, fd203, 0d3FCC7B90E3024582;
sub.f64 fd229, fd175, fd228;
mul.f64 fd230, fd205, 0d3FECD4BCA9CB5C71;
sub.f64 fd231, fd229, fd230;
fma.rn.f64 fd232, fd207, 0d3FE3F3A0E28BEDD1, fd231;
mul.f64 fd233, fd218, 0d3FEF329C0558E969;
mul.f64 fd234, fd220, 0d3FDBC4C04D71ABC1;
sub.f64 fd235, fd234, fd233;
fma.rn.f64 fd236, fd223, 0d3FE904C37505DE4B, fd235;
sub.f64 fd237, fd232, fd236;
add.f64 fd238, fd236, fd232;
mul.f64 fd239, fd203, 0d3FECD4BCA9CB5C71;
sub.f64 fd240, fd175, fd239;
fma.rn.f64 fd241, fd205, 0d3FE3F3A0E28BEDD1, fd240;
mul.f64 fd242, fd207, 0d3FCC7B90E3024582;
sub.f64 fd243, fd241, fd242;
mul.f64 fd244, fd218, 0d3FDBC4C04D71ABC1;
mul.f64 fd245, fd220, 0d3FE904C37505DE4B;
sub.f64 fd246, fd245, fd244;
mul.f64 fd247, fd223, 0d3FEF329C0558E969;
sub.f64 fd248, fd246, fd247;
sub.f64 fd249, fd243, fd248;
add.f64 fd250, fd248, fd243;
fma.rn.f64 fd251, fd208, 0d3FE3F3A0E28BEDD1, fd176;
mul.f64 fd252, fd210, 0d3FCC7B90E3024582;
sub.f64 fd253, fd251, fd252;
mul.f64 fd254, fd212, 0d3FECD4BCA9CB5C71;
sub.f64 fd255, fd253, fd254;
sub.f64 fd256, fd179, fd199;
mul.f64 fd257, fd256, 0d3FE904C37505DE4B;
sub.f64 fd258, fd183, fd195;
mul.f64 fd259, fd258, 0dBFEF329C0558E969;
sub.f64 fd260, fd259, fd257;
sub.f64 fd261, fd187, fd191;
mul.f64 fd262, fd261, 0d3FDBC4C04D71ABC1;
sub.f64 fd263, fd260, fd262;
add.f64 fd264, fd263, fd255;
sub.f64 fd265, fd255, fd263;
mul.f64 fd266, fd208, 0d3FCC7B90E3024582;
sub.f64 fd267, fd176, fd266;
mul.f64 fd268, fd210, 0d3FECD4BCA9CB5C71;
sub.f64 fd269, fd267, fd268;
fma.rn.f64 fd270, fd212, 0d3FE3F3A0E28BEDD1, fd269;
mul.f64 fd271, fd256, 0d3FEF329C0558E969;
mul.f64 fd272, fd258, 0d3FDBC4C04D71ABC1;
sub.f64 fd273, fd272, fd271;
fma.rn.f64 fd274, fd261, 0d3FE904C37505DE4B, fd273;
add.f64 fd275, fd274, fd270;
sub.f64 fd276, fd270, fd274;
mul.f64 fd277, fd208, 0d3FECD4BCA9CB5C71;
sub.f64 fd278, fd176, fd277;
fma.rn.f64 fd279, fd210, 0d3FE3F3A0E28BEDD1, fd278;
mul.f64 fd280, fd212, 0d3FCC7B90E3024582;
sub.f64 fd281, fd279, fd280;
mul.f64 fd282, fd256, 0d3FDBC4C04D71ABC1;
mul.f64 fd283, fd258, 0d3FE904C37505DE4B;
sub.f64 fd284, fd283, fd282;
mul.f64 fd285, fd261, 0d3FEF329C0558E969;
sub.f64 fd286, fd284, fd285;
add.f64 fd287, fd286, fd281;
sub.f64 fd288, fd281, fd286;
mul.wide.u32 rd7, r7, 613566757;
shr.u64 rd8, rd7, 32;
cvt.u32.u64 r11, rd8;
sub.s32 r12, r7, r11;
shr.u32 r13, r12, 1;
add.s32 r14, r13, r11;
shr.u32 r15, r14, 2;
mul.lo.s32 r16, r15, 7;
sub.s32 r17, r7, r16;
mul.wide.u32 rd9, r15, 16;
mov.u64 rd10, %16;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd289, fd290}, [rd11];
mul.f64 fd293, fd289, fd226;
mul.f64 fd294, fd290, fd264;
mul.f64 fd295, fd289, fd264;
mul.f64 fd296, fd289, fd289;
mul.f64 fd297, fd290, fd290;
sub.f64 fd298, fd296, fd297;
mul.f64 fd299, fd290, fd289;
fma.rn.f64 fd300, fd290, fd289, fd299;
mul.f64 fd301, fd298, fd237;
mul.f64 fd302, fd300, fd275;
mul.f64 fd303, fd298, fd275;
mul.f64 fd304, fd289, fd298;
mul.f64 fd305, fd290, fd300;
sub.f64 fd306, fd304, fd305;
mul.f64 fd307, fd289, fd300;
fma.rn.f64 fd308, fd290, fd298, fd307;
mul.f64 fd309, fd306, fd249;
mul.f64 fd310, fd308, fd287;
mul.f64 fd311, fd306, fd287;
ld.global.v2.f64 {fd312, fd313}, [rd11+784];
mul.f64 fd316, fd312, fd250;
mul.f64 fd317, fd313, fd288;
mul.f64 fd318, fd312, fd288;
mul.f64 fd319, fd289, fd312;
mul.f64 fd320, fd290, fd313;
sub.f64 fd321, fd319, fd320;
mul.f64 fd322, fd289, fd313;
fma.rn.f64 fd323, fd290, fd312, fd322;
mul.f64 fd324, fd321, fd238;
mul.f64 fd325, fd323, fd276;
mul.f64 fd326, fd321, fd276;
mul.f64 fd327, fd289, fd321;
mul.f64 fd328, fd290, fd323;
sub.f64 fd329, fd327, fd328;
mul.f64 fd330, fd289, fd323;
fma.rn.f64 fd331, fd290, fd321, fd330;
mul.f64 fd332, fd329, fd227;
mul.f64 fd333, fd331, fd265;
mul.f64 fd334, fd329, fd265;
shl.b32 r18, r17, 4;
add.s32 r19, r8, r18;
barrier.sync 0;
mad.lo.s32 r20, r15, 784, r19;
add.f64 fd335, fd212, fd211;
add.f64 fd336, fd207, fd206;
st.shared.v2.f64 [r20], {fd336, fd335};
fma.rn.f64 fd337, fd290, fd226, fd295;
sub.f64 fd338, fd293, fd294;
st.shared.v2.f64 [r20+112], {fd338, fd337};
fma.rn.f64 fd339, fd300, fd237, fd303;
sub.f64 fd340, fd301, fd302;
st.shared.v2.f64 [r20+224], {fd340, fd339};
fma.rn.f64 fd341, fd308, fd249, fd311;
sub.f64 fd342, fd309, fd310;
st.shared.v2.f64 [r20+336], {fd342, fd341};
fma.rn.f64 fd343, fd313, fd250, fd318;
sub.f64 fd344, fd316, fd317;
st.shared.v2.f64 [r20+448], {fd344, fd343};
fma.rn.f64 fd345, fd323, fd238, fd326;
sub.f64 fd346, fd324, fd325;
st.shared.v2.f64 [r20+560], {fd346, fd345};
fma.rn.f64 fd347, fd331, fd227, fd334;
sub.f64 fd348, fd332, fd333;
st.shared.v2.f64 [r20+672], {fd348, fd347};
barrier.sync 0;
ld.shared.v2.f64 {fd349, fd350}, [r10];
ld.shared.v2.f64 {fd353, fd354}, [r10+5488];
ld.shared.v2.f64 {fd357, fd358}, [r10+10976];
ld.shared.v2.f64 {fd361, fd362}, [r10+16464];
ld.shared.v2.f64 {fd365, fd366}, [r10+21952];
ld.shared.v2.f64 {fd369, fd370}, [r10+27440];
ld.shared.v2.f64 {fd373, fd374}, [r10+32928];
add.f64 fd377, fd353, fd373;
add.f64 fd378, fd349, fd377;
add.f64 fd379, fd357, fd369;
add.f64 fd380, fd379, fd378;
add.f64 fd381, fd361, fd365;
add.f64 fd382, fd354, fd374;
add.f64 fd383, fd350, fd382;
add.f64 fd384, fd358, fd370;
add.f64 fd385, fd384, fd383;
add.f64 fd386, fd362, fd366;
fma.rn.f64 fd387, fd377, 0d3FE3F3A0E28BEDD1, fd349;
mul.f64 fd388, fd379, 0d3FCC7B90E3024582;
sub.f64 fd389, fd387, fd388;
mul.f64 fd390, fd381, 0d3FECD4BCA9CB5C71;
sub.f64 fd391, fd389, fd390;
sub.f64 fd392, fd354, fd374;
mul.f64 fd393, fd392, 0d3FE904C37505DE4B;
sub.f64 fd394, fd358, fd370;
mul.f64 fd395, fd394, 0dBFEF329C0558E969;
sub.f64 fd396, fd395, fd393;
sub.f64 fd397, fd362, fd366;
mul.f64 fd398, fd397, 0d3FDBC4C04D71ABC1;
sub.f64 fd399, fd396, fd398;
sub.f64 fd400, fd391, fd399;
add.f64 fd401, fd399, fd391;
mul.f64 fd402, fd377, 0d3FCC7B90E3024582;
sub.f64 fd403, fd349, fd402;
mul.f64 fd404, fd379, 0d3FECD4BCA9CB5C71;
sub.f64 fd405, fd403, fd404;
fma.rn.f64 fd406, fd381, 0d3FE3F3A0E28BEDD1, fd405;
mul.f64 fd407, fd392, 0d3FEF329C0558E969;
mul.f64 fd408, fd394, 0d3FDBC4C04D71ABC1;
sub.f64 fd409, fd408, fd407;
fma.rn.f64 fd410, fd397, 0d3FE904C37505DE4B, fd409;
sub.f64 fd411, fd406, fd410;
add.f64 fd412, fd410, fd406;
mul.f64 fd413, fd377, 0d3FECD4BCA9CB5C71;
sub.f64 fd414, fd349, fd413;
fma.rn.f64 fd415, fd379, 0d3FE3F3A0E28BEDD1, fd414;
mul.f64 fd416, fd381, 0d3FCC7B90E3024582;
sub.f64 fd417, fd415, fd416;
mul.f64 fd418, fd392, 0d3FDBC4C04D71ABC1;
mul.f64 fd419, fd394, 0d3FE904C37505DE4B;
sub.f64 fd420, fd419, fd418;
mul.f64 fd421, fd397, 0d3FEF329C0558E969;
sub.f64 fd422, fd420, fd421;
sub.f64 fd423, fd417, fd422;
add.f64 fd424, fd422, fd417;
fma.rn.f64 fd425, fd382, 0d3FE3F3A0E28BEDD1, fd350;
mul.f64 fd426, fd384, 0d3FCC7B90E3024582;
sub.f64 fd427, fd425, fd426;
mul.f64 fd428, fd386, 0d3FECD4BCA9CB5C71;
sub.f64 fd429, fd427, fd428;
sub.f64 fd430, fd353, fd373;
mul.f64 fd431, fd430, 0d3FE904C37505DE4B;
sub.f64 fd432, fd357, fd369;
mul.f64 fd433, fd432, 0dBFEF329C0558E969;
sub.f64 fd434, fd433, fd431;
sub.f64 fd435, fd361, fd365;
mul.f64 fd436, fd435, 0d3FDBC4C04D71ABC1;
sub.f64 fd437, fd434, fd436;
add.f64 fd438, fd437, fd429;
sub.f64 fd439, fd429, fd437;
mul.f64 fd440, fd382, 0d3FCC7B90E3024582;
sub.f64 fd441, fd350, fd440;
mul.f64 fd442, fd384, 0d3FECD4BCA9CB5C71;
sub.f64 fd443, fd441, fd442;
fma.rn.f64 fd444, fd386, 0d3FE3F3A0E28BEDD1, fd443;
mul.f64 fd445, fd430, 0d3FEF329C0558E969;
mul.f64 fd446, fd432, 0d3FDBC4C04D71ABC1;
sub.f64 fd447, fd446, fd445;
fma.rn.f64 fd448, fd435, 0d3FE904C37505DE4B, fd447;
add.f64 fd449, fd448, fd444;
sub.f64 fd450, fd444, fd448;
mul.f64 fd451, fd382, 0d3FECD4BCA9CB5C71;
sub.f64 fd452, fd350, fd451;
fma.rn.f64 fd453, fd384, 0d3FE3F3A0E28BEDD1, fd452;
mul.f64 fd454, fd386, 0d3FCC7B90E3024582;
sub.f64 fd455, fd453, fd454;
mul.f64 fd456, fd430, 0d3FDBC4C04D71ABC1;
mul.f64 fd457, fd432, 0d3FE904C37505DE4B;
sub.f64 fd458, fd457, fd456;
mul.f64 fd459, fd435, 0d3FEF329C0558E969;
sub.f64 fd460, fd458, fd459;
add.f64 fd461, fd460, fd455;
sub.f64 fd462, fd455, fd460;
mul.wide.u32 rd12, r7, 1402438301;
shr.u64 rd13, rd12, 36;
cvt.u32.u64 r21, rd13;
mul.lo.s32 r22, r21, 49;
sub.s32 r23, r7, r22;
mul.wide.u32 rd14, r21, 16;
mov.u64 rd15, %17;
add.s64 rd16, rd15, rd14;
ld.global.v2.f64 {fd463, fd464}, [rd16];
mul.f64 fd467, fd463, fd400;
mul.f64 fd468, fd464, fd438;
mul.f64 fd469, fd463, fd438;
mul.f64 fd470, fd463, fd463;
mul.f64 fd471, fd464, fd464;
sub.f64 fd472, fd470, fd471;
mul.f64 fd473, fd464, fd463;
fma.rn.f64 fd474, fd464, fd463, fd473;
mul.f64 fd475, fd472, fd411;
mul.f64 fd476, fd474, fd449;
mul.f64 fd477, fd472, fd449;
mul.f64 fd478, fd463, fd472;
mul.f64 fd479, fd464, fd474;
sub.f64 fd480, fd478, fd479;
mul.f64 fd481, fd463, fd474;
fma.rn.f64 fd482, fd464, fd472, fd481;
mul.f64 fd483, fd480, fd423;
mul.f64 fd484, fd482, fd461;
mul.f64 fd485, fd480, fd461;
ld.global.v2.f64 {fd486, fd487}, [rd16+112];
mul.f64 fd490, fd486, fd424;
mul.f64 fd491, fd487, fd462;
mul.f64 fd492, fd486, fd462;
mul.f64 fd493, fd463, fd486;
mul.f64 fd494, fd464, fd487;
sub.f64 fd495, fd493, fd494;
mul.f64 fd496, fd463, fd487;
fma.rn.f64 fd497, fd464, fd486, fd496;
mul.f64 fd498, fd495, fd412;
mul.f64 fd499, fd497, fd450;
mul.f64 fd500, fd495, fd450;
mul.f64 fd501, fd463, fd495;
mul.f64 fd502, fd464, fd497;
sub.f64 fd503, fd501, fd502;
mul.f64 fd504, fd463, fd497;
fma.rn.f64 fd505, fd464, fd495, fd504;
mul.f64 fd506, fd503, fd401;
mul.f64 fd507, fd505, fd439;
mul.f64 fd508, fd503, fd439;
shl.b32 r24, r23, 4;
add.s32 r25, r8, r24;
barrier.sync 0;
mad.lo.s32 r26, r21, 5488, r25;
add.f64 fd509, fd386, fd385;
add.f64 fd510, fd381, fd380;
st.shared.v2.f64 [r26], {fd510, fd509};
fma.rn.f64 fd511, fd464, fd400, fd469;
sub.f64 fd512, fd467, fd468;
st.shared.v2.f64 [r26+784], {fd512, fd511};
fma.rn.f64 fd513, fd474, fd411, fd477;
sub.f64 fd514, fd475, fd476;
st.shared.v2.f64 [r26+1568], {fd514, fd513};
fma.rn.f64 fd515, fd482, fd423, fd485;
sub.f64 fd516, fd483, fd484;
st.shared.v2.f64 [r26+2352], {fd516, fd515};
fma.rn.f64 fd517, fd487, fd424, fd492;
sub.f64 fd518, fd490, fd491;
st.shared.v2.f64 [r26+3136], {fd518, fd517};
fma.rn.f64 fd519, fd497, fd412, fd500;
sub.f64 fd520, fd498, fd499;
st.shared.v2.f64 [r26+3920], {fd520, fd519};
fma.rn.f64 fd521, fd505, fd401, fd508;
sub.f64 fd522, fd506, fd507;
st.shared.v2.f64 [r26+4704], {fd522, fd521};
barrier.sync 0;
ld.shared.v2.f64 {fd523, fd524}, [r10];
ld.shared.v2.f64 {fd527, fd528}, [r10+5488];
ld.shared.v2.f64 {fd531, fd532}, [r10+10976];
ld.shared.v2.f64 {fd535, fd536}, [r10+16464];
ld.shared.v2.f64 {fd539, fd540}, [r10+21952];
ld.shared.v2.f64 {fd543, fd544}, [r10+27440];
ld.shared.v2.f64 {fd547, fd548}, [r10+32928];
add.f64 fd551, fd527, fd547;
add.f64 fd552, fd523, fd551;
add.f64 fd553, fd531, fd543;
add.f64 fd554, fd553, fd552;
add.f64 fd555, fd535, fd539;
add.f64 fd556, fd528, fd548;
add.f64 fd557, fd524, fd556;
add.f64 fd558, fd532, fd544;
add.f64 fd559, fd558, fd557;
add.f64 fd560, fd536, fd540;
fma.rn.f64 fd561, fd551, 0d3FE3F3A0E28BEDD1, fd523;
mul.f64 fd562, fd553, 0d3FCC7B90E3024582;
sub.f64 fd563, fd561, fd562;
mul.f64 fd564, fd555, 0d3FECD4BCA9CB5C71;
sub.f64 fd565, fd563, fd564;
sub.f64 fd566, fd528, fd548;
mul.f64 fd567, fd566, 0d3FE904C37505DE4B;
sub.f64 fd568, fd532, fd544;
mul.f64 fd569, fd568, 0dBFEF329C0558E969;
sub.f64 fd570, fd569, fd567;
sub.f64 fd571, fd536, fd540;
mul.f64 fd572, fd571, 0d3FDBC4C04D71ABC1;
sub.f64 fd573, fd570, fd572;
mul.f64 fd574, fd551, 0d3FCC7B90E3024582;
sub.f64 fd575, fd523, fd574;
mul.f64 fd576, fd553, 0d3FECD4BCA9CB5C71;
sub.f64 fd577, fd575, fd576;
fma.rn.f64 fd578, fd555, 0d3FE3F3A0E28BEDD1, fd577;
mul.f64 fd579, fd566, 0d3FEF329C0558E969;
mul.f64 fd580, fd568, 0d3FDBC4C04D71ABC1;
sub.f64 fd581, fd580, fd579;
fma.rn.f64 fd582, fd571, 0d3FE904C37505DE4B, fd581;
mul.f64 fd583, fd551, 0d3FECD4BCA9CB5C71;
sub.f64 fd584, fd523, fd583;
fma.rn.f64 fd585, fd553, 0d3FE3F3A0E28BEDD1, fd584;
mul.f64 fd586, fd555, 0d3FCC7B90E3024582;
sub.f64 fd587, fd585, fd586;
mul.f64 fd588, fd566, 0d3FDBC4C04D71ABC1;
mul.f64 fd589, fd568, 0d3FE904C37505DE4B;
sub.f64 fd590, fd589, fd588;
mul.f64 fd591, fd571, 0d3FEF329C0558E969;
sub.f64 fd592, fd590, fd591;
fma.rn.f64 fd593, fd556, 0d3FE3F3A0E28BEDD1, fd524;
mul.f64 fd594, fd558, 0d3FCC7B90E3024582;
sub.f64 fd595, fd593, fd594;
mul.f64 fd596, fd560, 0d3FECD4BCA9CB5C71;
sub.f64 fd597, fd595, fd596;
sub.f64 fd598, fd527, fd547;
mul.f64 fd599, fd598, 0d3FE904C37505DE4B;
sub.f64 fd600, fd531, fd543;
mul.f64 fd601, fd600, 0dBFEF329C0558E969;
sub.f64 fd602, fd601, fd599;
sub.f64 fd603, fd535, fd539;
mul.f64 fd604, fd603, 0d3FDBC4C04D71ABC1;
sub.f64 fd605, fd602, fd604;
mul.f64 fd606, fd556, 0d3FCC7B90E3024582;
sub.f64 fd607, fd524, fd606;
mul.f64 fd608, fd558, 0d3FECD4BCA9CB5C71;
sub.f64 fd609, fd607, fd608;
fma.rn.f64 fd610, fd560, 0d3FE3F3A0E28BEDD1, fd609;
mul.f64 fd611, fd598, 0d3FEF329C0558E969;
mul.f64 fd612, fd600, 0d3FDBC4C04D71ABC1;
sub.f64 fd613, fd612, fd611;
fma.rn.f64 fd614, fd603, 0d3FE904C37505DE4B, fd613;
mul.f64 fd615, fd556, 0d3FECD4BCA9CB5C71;
sub.f64 fd616, fd524, fd615;
fma.rn.f64 fd617, fd558, 0d3FE3F3A0E28BEDD1, fd616;
mul.f64 fd618, fd560, 0d3FCC7B90E3024582;
sub.f64 fd619, fd617, fd618;
mul.f64 fd620, fd598, 0d3FDBC4C04D71ABC1;
mul.f64 fd621, fd600, 0d3FE904C37505DE4B;
sub.f64 fd622, fd621, fd620;
mul.f64 fd623, fd603, 0d3FEF329C0558E969;
sub.f64 fd624, fd622, fd623;
add.f64 %1, fd560, fd559;
add.f64 %0, fd555, fd554;
add.f64 %3, fd605, fd597;
sub.f64 %2, fd565, fd573;
add.f64 %5, fd614, fd610;
sub.f64 %4, fd578, fd582;
add.f64 %7, fd624, fd619;
sub.f64 %6, fd587, fd592;
sub.f64 %9, fd619, fd624;
add.f64 %8, fd592, fd587;
sub.f64 %11, fd610, fd614;
add.f64 %10, fd582, fd578;
sub.f64 %13, fd597, fd605;
add.f64 %12, fd573, fd565;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y): "r"(smem), "l"(lut_dp_7_2401), "l"(lut_dp_7_343), "l"(lut_dp_7_49), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<552, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<27>;
.reg .f64 fd<597>;
.reg .b64 rd<17>;
mov.u32 r1, %tid.y;
mov.u32 r2, %14;
mad.lo.s32 r3, r1, 19208, r2;
mov.u32 r4, %tid.x;
add.f64 fd29, %20, %34;
add.f64 fd30, %18, fd29;
add.f64 fd31, %23, %31;
add.f64 fd32, fd31, fd30;
add.f64 fd33, %26, %28;
add.f64 fd34, fd33, fd32;
add.f64 fd35, %22, %35;
add.f64 fd36, %19, fd35;
add.f64 fd37, %25, %33;
add.f64 fd38, fd37, fd36;
add.f64 fd39, %27, %30;
add.f64 fd40, fd39, fd38;
fma.rn.f64 fd41, fd29, 0d3FE3F3A0E28BEDD1, %18;
mul.f64 fd42, fd31, 0d3FCC7B90E3024582;
sub.f64 fd43, fd41, fd42;
mul.f64 fd44, fd33, 0d3FECD4BCA9CB5C71;
sub.f64 fd45, fd43, fd44;
sub.f64 fd46, %22, %35;
mul.f64 fd47, fd46, 0d3FE904C37505DE4B;
sub.f64 fd48, %25, %33;
mul.f64 fd49, fd48, 0dBFEF329C0558E969;
sub.f64 fd50, fd49, fd47;
sub.f64 fd51, %27, %30;
mul.f64 fd52, fd51, 0d3FDBC4C04D71ABC1;
sub.f64 fd53, fd50, fd52;
sub.f64 fd54, fd45, fd53;
add.f64 fd55, fd53, fd45;
mul.f64 fd56, fd29, 0d3FCC7B90E3024582;
sub.f64 fd57, %18, fd56;
mul.f64 fd58, fd31, 0d3FECD4BCA9CB5C71;
sub.f64 fd59, fd57, fd58;
fma.rn.f64 fd60, fd33, 0d3FE3F3A0E28BEDD1, fd59;
mul.f64 fd61, fd46, 0d3FEF329C0558E969;
mul.f64 fd62, fd48, 0d3FDBC4C04D71ABC1;
sub.f64 fd63, fd62, fd61;
fma.rn.f64 fd64, fd51, 0d3FE904C37505DE4B, fd63;
sub.f64 fd65, fd60, fd64;
add.f64 fd66, fd64, fd60;
mul.f64 fd67, fd29, 0d3FECD4BCA9CB5C71;
sub.f64 fd68, %18, fd67;
fma.rn.f64 fd69, fd31, 0d3FE3F3A0E28BEDD1, fd68;
mul.f64 fd70, fd33, 0d3FCC7B90E3024582;
sub.f64 fd71, fd69, fd70;
mul.f64 fd72, fd46, 0d3FDBC4C04D71ABC1;
mul.f64 fd73, fd48, 0d3FE904C37505DE4B;
sub.f64 fd74, fd73, fd72;
mul.f64 fd75, fd51, 0d3FEF329C0558E969;
sub.f64 fd76, fd74, fd75;
sub.f64 fd77, fd71, fd76;
add.f64 fd78, fd76, fd71;
fma.rn.f64 fd79, fd35, 0d3FE3F3A0E28BEDD1, %19;
mul.f64 fd80, fd37, 0d3FCC7B90E3024582;
sub.f64 fd81, fd79, fd80;
mul.f64 fd82, fd39, 0d3FECD4BCA9CB5C71;
sub.f64 fd83, fd81, fd82;
sub.f64 fd84, %20, %34;
mul.f64 fd85, fd84, 0d3FE904C37505DE4B;
sub.f64 fd86, %23, %31;
mul.f64 fd87, fd86, 0dBFEF329C0558E969;
sub.f64 fd88, fd87, fd85;
sub.f64 fd89, %26, %28;
mul.f64 fd90, fd89, 0d3FDBC4C04D71ABC1;
sub.f64 fd91, fd88, fd90;
add.f64 fd92, fd91, fd83;
sub.f64 fd93, fd83, fd91;
mul.f64 fd94, fd35, 0d3FCC7B90E3024582;
sub.f64 fd95, %19, fd94;
mul.f64 fd96, fd37, 0d3FECD4BCA9CB5C71;
sub.f64 fd97, fd95, fd96;
fma.rn.f64 fd98, fd39, 0d3FE3F3A0E28BEDD1, fd97;
mul.f64 fd99, fd84, 0d3FEF329C0558E969;
mul.f64 fd100, fd86, 0d3FDBC4C04D71ABC1;
sub.f64 fd101, fd100, fd99;
fma.rn.f64 fd102, fd89, 0d3FE904C37505DE4B, fd101;
add.f64 fd103, fd102, fd98;
sub.f64 fd104, fd98, fd102;
mul.f64 fd105, fd35, 0d3FECD4BCA9CB5C71;
sub.f64 fd106, %19, fd105;
fma.rn.f64 fd107, fd37, 0d3FE3F3A0E28BEDD1, fd106;
mul.f64 fd108, fd39, 0d3FCC7B90E3024582;
sub.f64 fd109, fd107, fd108;
mul.f64 fd110, fd84, 0d3FDBC4C04D71ABC1;
mul.f64 fd111, fd86, 0d3FE904C37505DE4B;
sub.f64 fd112, fd111, fd110;
mul.f64 fd113, fd89, 0d3FEF329C0558E969;
sub.f64 fd114, fd112, fd113;
add.f64 fd115, fd114, fd109;
sub.f64 fd116, fd109, fd114;
mul.wide.u32 rd2, r4, -1089394037;
shr.u64 rd3, rd2, 40;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 343;
sub.s32 r7, r4, r6;
mul.wide.u32 rd4, r7, 16;
mov.u64 rd5, %15;
add.s64 rd6, rd5, rd4;
ld.global.v2.f64 {fd117, fd118}, [rd6];
mul.f64 fd121, fd117, fd54;
mul.f64 fd122, fd118, fd92;
sub.f64 fd123, fd121, fd122;
mul.f64 fd124, fd117, fd92;
fma.rn.f64 fd125, fd118, fd54, fd124;
mul.f64 fd126, fd117, fd117;
mul.f64 fd127, fd118, fd118;
sub.f64 fd128, fd126, fd127;
mul.f64 fd129, fd118, fd117;
fma.rn.f64 fd130, fd118, fd117, fd129;
mul.f64 fd131, fd128, fd65;
mul.f64 fd132, fd130, fd103;
sub.f64 fd133, fd131, fd132;
mul.f64 fd134, fd128, fd103;
fma.rn.f64 fd135, fd130, fd65, fd134;
mul.f64 fd136, fd117, fd128;
mul.f64 fd137, fd118, fd130;
sub.f64 fd138, fd136, fd137;
mul.f64 fd139, fd117, fd130;
fma.rn.f64 fd140, fd118, fd128, fd139;
mul.f64 fd141, fd138, fd77;
mul.f64 fd142, fd140, fd115;
sub.f64 fd143, fd141, fd142;
mul.f64 fd144, fd138, fd115;
fma.rn.f64 fd145, fd140, fd77, fd144;
ld.global.v2.f64 {fd146, fd147}, [rd6+5488];
mul.f64 fd150, fd146, fd78;
mul.f64 fd151, fd147, fd116;
sub.f64 fd152, fd150, fd151;
mul.f64 fd153, fd146, fd116;
fma.rn.f64 fd154, fd147, fd78, fd153;
mul.f64 fd155, fd117, fd146;
mul.f64 fd156, fd118, fd147;
sub.f64 fd157, fd155, fd156;
mul.f64 fd158, fd117, fd147;
fma.rn.f64 fd159, fd118, fd146, fd158;
mul.f64 fd160, fd157, fd66;
mul.f64 fd161, fd159, fd104;
sub.f64 fd162, fd160, fd161;
mul.f64 fd163, fd157, fd104;
fma.rn.f64 fd164, fd159, fd66, fd163;
mul.f64 fd165, fd117, fd157;
mul.f64 fd166, fd118, fd159;
sub.f64 fd167, fd165, fd166;
mul.f64 fd168, fd117, fd159;
fma.rn.f64 fd169, fd118, fd157, fd168;
mul.f64 fd170, fd167, fd55;
mul.f64 fd171, fd169, fd93;
sub.f64 fd172, fd170, fd171;
mul.f64 fd173, fd167, fd93;
fma.rn.f64 fd174, fd169, fd55, fd173;
mad.lo.s32 r8, r5, 19208, r3;
barrier.sync 0;
mad.lo.s32 r9, r7, 56, r8;
st.shared.f64 [r9], fd34;
st.shared.f64 [r9+8], fd123;
st.shared.f64 [r9+16], fd133;
st.shared.f64 [r9+24], fd143;
st.shared.f64 [r9+32], fd152;
st.shared.f64 [r9+40], fd162;
st.shared.f64 [r9+48], fd172;
barrier.sync 0;
mad.lo.s32 r10, r7, -48, r9;
ld.shared.f64 fd175, [r10];
ld.shared.f64 fd176, [r10+2744];
ld.shared.f64 fd177, [r10+5488];
ld.shared.f64 fd178, [r10+8232];
ld.shared.f64 fd179, [r10+10976];
ld.shared.f64 fd180, [r10+13720];
ld.shared.f64 fd181, [r10+16464];
barrier.sync 0;
st.shared.f64 [r9], fd40;
st.shared.f64 [r9+8], fd125;
st.shared.f64 [r9+16], fd135;
st.shared.f64 [r9+24], fd145;
st.shared.f64 [r9+32], fd154;
st.shared.f64 [r9+40], fd164;
st.shared.f64 [r9+48], fd174;
barrier.sync 0;
ld.shared.f64 fd182, [r10];
ld.shared.f64 fd183, [r10+2744];
ld.shared.f64 fd184, [r10+5488];
ld.shared.f64 fd185, [r10+8232];
ld.shared.f64 fd186, [r10+10976];
ld.shared.f64 fd187, [r10+13720];
ld.shared.f64 fd188, [r10+16464];
add.f64 fd189, fd176, fd181;
add.f64 fd190, fd175, fd189;
add.f64 fd191, fd177, fd180;
add.f64 fd192, fd191, fd190;
add.f64 fd193, fd178, fd179;
add.f64 fd194, fd193, fd192;
add.f64 fd195, fd183, fd188;
add.f64 fd196, fd182, fd195;
add.f64 fd197, fd184, fd187;
add.f64 fd198, fd197, fd196;
add.f64 fd199, fd185, fd186;
add.f64 fd200, fd199, fd198;
fma.rn.f64 fd201, fd189, 0d3FE3F3A0E28BEDD1, fd175;
mul.f64 fd202, fd191, 0d3FCC7B90E3024582;
sub.f64 fd203, fd201, fd202;
mul.f64 fd204, fd193, 0d3FECD4BCA9CB5C71;
sub.f64 fd205, fd203, fd204;
sub.f64 fd206, fd183, fd188;
mul.f64 fd207, fd206, 0d3FE904C37505DE4B;
sub.f64 fd208, fd184, fd187;
mul.f64 fd209, fd208, 0dBFEF329C0558E969;
sub.f64 fd210, fd209, fd207;
sub.f64 fd211, fd185, fd186;
mul.f64 fd212, fd211, 0d3FDBC4C04D71ABC1;
sub.f64 fd213, fd210, fd212;
sub.f64 fd214, fd205, fd213;
add.f64 fd215, fd213, fd205;
mul.f64 fd216, fd189, 0d3FCC7B90E3024582;
sub.f64 fd217, fd175, fd216;
mul.f64 fd218, fd191, 0d3FECD4BCA9CB5C71;
sub.f64 fd219, fd217, fd218;
fma.rn.f64 fd220, fd193, 0d3FE3F3A0E28BEDD1, fd219;
mul.f64 fd221, fd206, 0d3FEF329C0558E969;
mul.f64 fd222, fd208, 0d3FDBC4C04D71ABC1;
sub.f64 fd223, fd222, fd221;
fma.rn.f64 fd224, fd211, 0d3FE904C37505DE4B, fd223;
sub.f64 fd225, fd220, fd224;
add.f64 fd226, fd224, fd220;
mul.f64 fd227, fd189, 0d3FECD4BCA9CB5C71;
sub.f64 fd228, fd175, fd227;
fma.rn.f64 fd229, fd191, 0d3FE3F3A0E28BEDD1, fd228;
mul.f64 fd230, fd193, 0d3FCC7B90E3024582;
sub.f64 fd231, fd229, fd230;
mul.f64 fd232, fd206, 0d3FDBC4C04D71ABC1;
mul.f64 fd233, fd208, 0d3FE904C37505DE4B;
sub.f64 fd234, fd233, fd232;
mul.f64 fd235, fd211, 0d3FEF329C0558E969;
sub.f64 fd236, fd234, fd235;
sub.f64 fd237, fd231, fd236;
add.f64 fd238, fd236, fd231;
fma.rn.f64 fd239, fd195, 0d3FE3F3A0E28BEDD1, fd182;
mul.f64 fd240, fd197, 0d3FCC7B90E3024582;
sub.f64 fd241, fd239, fd240;
mul.f64 fd242, fd199, 0d3FECD4BCA9CB5C71;
sub.f64 fd243, fd241, fd242;
sub.f64 fd244, fd176, fd181;
mul.f64 fd245, fd244, 0d3FE904C37505DE4B;
sub.f64 fd246, fd177, fd180;
mul.f64 fd247, fd246, 0dBFEF329C0558E969;
sub.f64 fd248, fd247, fd245;
sub.f64 fd249, fd178, fd179;
mul.f64 fd250, fd249, 0d3FDBC4C04D71ABC1;
sub.f64 fd251, fd248, fd250;
add.f64 fd252, fd251, fd243;
sub.f64 fd253, fd243, fd251;
mul.f64 fd254, fd195, 0d3FCC7B90E3024582;
sub.f64 fd255, fd182, fd254;
mul.f64 fd256, fd197, 0d3FECD4BCA9CB5C71;
sub.f64 fd257, fd255, fd256;
fma.rn.f64 fd258, fd199, 0d3FE3F3A0E28BEDD1, fd257;
mul.f64 fd259, fd244, 0d3FEF329C0558E969;
mul.f64 fd260, fd246, 0d3FDBC4C04D71ABC1;
sub.f64 fd261, fd260, fd259;
fma.rn.f64 fd262, fd249, 0d3FE904C37505DE4B, fd261;
add.f64 fd263, fd262, fd258;
sub.f64 fd264, fd258, fd262;
mul.f64 fd265, fd195, 0d3FECD4BCA9CB5C71;
sub.f64 fd266, fd182, fd265;
fma.rn.f64 fd267, fd197, 0d3FE3F3A0E28BEDD1, fd266;
mul.f64 fd268, fd199, 0d3FCC7B90E3024582;
sub.f64 fd269, fd267, fd268;
mul.f64 fd270, fd244, 0d3FDBC4C04D71ABC1;
mul.f64 fd271, fd246, 0d3FE904C37505DE4B;
sub.f64 fd272, fd271, fd270;
mul.f64 fd273, fd249, 0d3FEF329C0558E969;
sub.f64 fd274, fd272, fd273;
add.f64 fd275, fd274, fd269;
sub.f64 fd276, fd269, fd274;
mul.wide.u32 rd7, r7, 613566757;
shr.u64 rd8, rd7, 32;
cvt.u32.u64 r11, rd8;
sub.s32 r12, r7, r11;
shr.u32 r13, r12, 1;
add.s32 r14, r13, r11;
shr.u32 r15, r14, 2;
mul.lo.s32 r16, r15, 7;
sub.s32 r17, r7, r16;
mul.wide.u32 rd9, r15, 16;
mov.u64 rd10, %16;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd277, fd278}, [rd11];
mul.f64 fd281, fd277, fd214;
mul.f64 fd282, fd278, fd252;
sub.f64 fd283, fd281, fd282;
mul.f64 fd284, fd277, fd252;
fma.rn.f64 fd285, fd278, fd214, fd284;
mul.f64 fd286, fd277, fd277;
mul.f64 fd287, fd278, fd278;
sub.f64 fd288, fd286, fd287;
mul.f64 fd289, fd278, fd277;
fma.rn.f64 fd290, fd278, fd277, fd289;
mul.f64 fd291, fd288, fd225;
mul.f64 fd292, fd290, fd263;
sub.f64 fd293, fd291, fd292;
mul.f64 fd294, fd288, fd263;
fma.rn.f64 fd295, fd290, fd225, fd294;
mul.f64 fd296, fd277, fd288;
mul.f64 fd297, fd278, fd290;
sub.f64 fd298, fd296, fd297;
mul.f64 fd299, fd277, fd290;
fma.rn.f64 fd300, fd278, fd288, fd299;
mul.f64 fd301, fd298, fd237;
mul.f64 fd302, fd300, fd275;
sub.f64 fd303, fd301, fd302;
mul.f64 fd304, fd298, fd275;
fma.rn.f64 fd305, fd300, fd237, fd304;
ld.global.v2.f64 {fd306, fd307}, [rd11+784];
mul.f64 fd310, fd306, fd238;
mul.f64 fd311, fd307, fd276;
sub.f64 fd312, fd310, fd311;
mul.f64 fd313, fd306, fd276;
fma.rn.f64 fd314, fd307, fd238, fd313;
mul.f64 fd315, fd277, fd306;
mul.f64 fd316, fd278, fd307;
sub.f64 fd317, fd315, fd316;
mul.f64 fd318, fd277, fd307;
fma.rn.f64 fd319, fd278, fd306, fd318;
mul.f64 fd320, fd317, fd226;
mul.f64 fd321, fd319, fd264;
sub.f64 fd322, fd320, fd321;
mul.f64 fd323, fd317, fd264;
fma.rn.f64 fd324, fd319, fd226, fd323;
mul.f64 fd325, fd277, fd317;
mul.f64 fd326, fd278, fd319;
sub.f64 fd327, fd325, fd326;
mul.f64 fd328, fd277, fd319;
fma.rn.f64 fd329, fd278, fd317, fd328;
mul.f64 fd330, fd327, fd215;
mul.f64 fd331, fd329, fd253;
sub.f64 fd332, fd330, fd331;
mul.f64 fd333, fd327, fd253;
fma.rn.f64 fd334, fd329, fd215, fd333;
shl.b32 r18, r17, 3;
add.s32 r19, r8, r18;
barrier.sync 0;
mad.lo.s32 r20, r15, 392, r19;
st.shared.f64 [r20], fd194;
st.shared.f64 [r20+56], fd283;
st.shared.f64 [r20+112], fd293;
st.shared.f64 [r20+168], fd303;
st.shared.f64 [r20+224], fd312;
st.shared.f64 [r20+280], fd322;
st.shared.f64 [r20+336], fd332;
barrier.sync 0;
ld.shared.f64 fd335, [r10];
ld.shared.f64 fd336, [r10+2744];
ld.shared.f64 fd337, [r10+5488];
ld.shared.f64 fd338, [r10+8232];
ld.shared.f64 fd339, [r10+10976];
ld.shared.f64 fd340, [r10+13720];
ld.shared.f64 fd341, [r10+16464];
barrier.sync 0;
st.shared.f64 [r20], fd200;
st.shared.f64 [r20+56], fd285;
st.shared.f64 [r20+112], fd295;
st.shared.f64 [r20+168], fd305;
st.shared.f64 [r20+224], fd314;
st.shared.f64 [r20+280], fd324;
st.shared.f64 [r20+336], fd334;
barrier.sync 0;
ld.shared.f64 fd342, [r10];
ld.shared.f64 fd343, [r10+2744];
ld.shared.f64 fd344, [r10+5488];
ld.shared.f64 fd345, [r10+8232];
ld.shared.f64 fd346, [r10+10976];
ld.shared.f64 fd347, [r10+13720];
ld.shared.f64 fd348, [r10+16464];
add.f64 fd349, fd336, fd341;
add.f64 fd350, fd335, fd349;
add.f64 fd351, fd337, fd340;
add.f64 fd352, fd351, fd350;
add.f64 fd353, fd338, fd339;
add.f64 fd354, fd353, fd352;
add.f64 fd355, fd343, fd348;
add.f64 fd356, fd342, fd355;
add.f64 fd357, fd344, fd347;
add.f64 fd358, fd357, fd356;
add.f64 fd359, fd345, fd346;
add.f64 fd360, fd359, fd358;
fma.rn.f64 fd361, fd349, 0d3FE3F3A0E28BEDD1, fd335;
mul.f64 fd362, fd351, 0d3FCC7B90E3024582;
sub.f64 fd363, fd361, fd362;
mul.f64 fd364, fd353, 0d3FECD4BCA9CB5C71;
sub.f64 fd365, fd363, fd364;
sub.f64 fd366, fd343, fd348;
mul.f64 fd367, fd366, 0d3FE904C37505DE4B;
sub.f64 fd368, fd344, fd347;
mul.f64 fd369, fd368, 0dBFEF329C0558E969;
sub.f64 fd370, fd369, fd367;
sub.f64 fd371, fd345, fd346;
mul.f64 fd372, fd371, 0d3FDBC4C04D71ABC1;
sub.f64 fd373, fd370, fd372;
sub.f64 fd374, fd365, fd373;
add.f64 fd375, fd373, fd365;
mul.f64 fd376, fd349, 0d3FCC7B90E3024582;
sub.f64 fd377, fd335, fd376;
mul.f64 fd378, fd351, 0d3FECD4BCA9CB5C71;
sub.f64 fd379, fd377, fd378;
fma.rn.f64 fd380, fd353, 0d3FE3F3A0E28BEDD1, fd379;
mul.f64 fd381, fd366, 0d3FEF329C0558E969;
mul.f64 fd382, fd368, 0d3FDBC4C04D71ABC1;
sub.f64 fd383, fd382, fd381;
fma.rn.f64 fd384, fd371, 0d3FE904C37505DE4B, fd383;
sub.f64 fd385, fd380, fd384;
add.f64 fd386, fd384, fd380;
mul.f64 fd387, fd349, 0d3FECD4BCA9CB5C71;
sub.f64 fd388, fd335, fd387;
fma.rn.f64 fd389, fd351, 0d3FE3F3A0E28BEDD1, fd388;
mul.f64 fd390, fd353, 0d3FCC7B90E3024582;
sub.f64 fd391, fd389, fd390;
mul.f64 fd392, fd366, 0d3FDBC4C04D71ABC1;
mul.f64 fd393, fd368, 0d3FE904C37505DE4B;
sub.f64 fd394, fd393, fd392;
mul.f64 fd395, fd371, 0d3FEF329C0558E969;
sub.f64 fd396, fd394, fd395;
sub.f64 fd397, fd391, fd396;
add.f64 fd398, fd396, fd391;
fma.rn.f64 fd399, fd355, 0d3FE3F3A0E28BEDD1, fd342;
mul.f64 fd400, fd357, 0d3FCC7B90E3024582;
sub.f64 fd401, fd399, fd400;
mul.f64 fd402, fd359, 0d3FECD4BCA9CB5C71;
sub.f64 fd403, fd401, fd402;
sub.f64 fd404, fd336, fd341;
mul.f64 fd405, fd404, 0d3FE904C37505DE4B;
sub.f64 fd406, fd337, fd340;
mul.f64 fd407, fd406, 0dBFEF329C0558E969;
sub.f64 fd408, fd407, fd405;
sub.f64 fd409, fd338, fd339;
mul.f64 fd410, fd409, 0d3FDBC4C04D71ABC1;
sub.f64 fd411, fd408, fd410;
add.f64 fd412, fd411, fd403;
sub.f64 fd413, fd403, fd411;
mul.f64 fd414, fd355, 0d3FCC7B90E3024582;
sub.f64 fd415, fd342, fd414;
mul.f64 fd416, fd357, 0d3FECD4BCA9CB5C71;
sub.f64 fd417, fd415, fd416;
fma.rn.f64 fd418, fd359, 0d3FE3F3A0E28BEDD1, fd417;
mul.f64 fd419, fd404, 0d3FEF329C0558E969;
mul.f64 fd420, fd406, 0d3FDBC4C04D71ABC1;
sub.f64 fd421, fd420, fd419;
fma.rn.f64 fd422, fd409, 0d3FE904C37505DE4B, fd421;
add.f64 fd423, fd422, fd418;
sub.f64 fd424, fd418, fd422;
mul.f64 fd425, fd355, 0d3FECD4BCA9CB5C71;
sub.f64 fd426, fd342, fd425;
fma.rn.f64 fd427, fd357, 0d3FE3F3A0E28BEDD1, fd426;
mul.f64 fd428, fd359, 0d3FCC7B90E3024582;
sub.f64 fd429, fd427, fd428;
mul.f64 fd430, fd404, 0d3FDBC4C04D71ABC1;
mul.f64 fd431, fd406, 0d3FE904C37505DE4B;
sub.f64 fd432, fd431, fd430;
mul.f64 fd433, fd409, 0d3FEF329C0558E969;
sub.f64 fd434, fd432, fd433;
add.f64 fd435, fd434, fd429;
sub.f64 fd436, fd429, fd434;
mul.wide.u32 rd12, r7, 1402438301;
shr.u64 rd13, rd12, 36;
cvt.u32.u64 r21, rd13;
mul.lo.s32 r22, r21, 49;
sub.s32 r23, r7, r22;
mul.wide.u32 rd14, r21, 16;
mov.u64 rd15, %17;
add.s64 rd16, rd15, rd14;
ld.global.v2.f64 {fd437, fd438}, [rd16];
mul.f64 fd441, fd437, fd374;
mul.f64 fd442, fd438, fd412;
sub.f64 fd443, fd441, fd442;
mul.f64 fd444, fd437, fd412;
fma.rn.f64 fd445, fd438, fd374, fd444;
mul.f64 fd446, fd437, fd437;
mul.f64 fd447, fd438, fd438;
sub.f64 fd448, fd446, fd447;
mul.f64 fd449, fd438, fd437;
fma.rn.f64 fd450, fd438, fd437, fd449;
mul.f64 fd451, fd448, fd385;
mul.f64 fd452, fd450, fd423;
sub.f64 fd453, fd451, fd452;
mul.f64 fd454, fd448, fd423;
fma.rn.f64 fd455, fd450, fd385, fd454;
mul.f64 fd456, fd437, fd448;
mul.f64 fd457, fd438, fd450;
sub.f64 fd458, fd456, fd457;
mul.f64 fd459, fd437, fd450;
fma.rn.f64 fd460, fd438, fd448, fd459;
mul.f64 fd461, fd458, fd397;
mul.f64 fd462, fd460, fd435;
sub.f64 fd463, fd461, fd462;
mul.f64 fd464, fd458, fd435;
fma.rn.f64 fd465, fd460, fd397, fd464;
ld.global.v2.f64 {fd466, fd467}, [rd16+112];
mul.f64 fd470, fd466, fd398;
mul.f64 fd471, fd467, fd436;
sub.f64 fd472, fd470, fd471;
mul.f64 fd473, fd466, fd436;
fma.rn.f64 fd474, fd467, fd398, fd473;
mul.f64 fd475, fd437, fd466;
mul.f64 fd476, fd438, fd467;
sub.f64 fd477, fd475, fd476;
mul.f64 fd478, fd437, fd467;
fma.rn.f64 fd479, fd438, fd466, fd478;
mul.f64 fd480, fd477, fd386;
mul.f64 fd481, fd479, fd424;
sub.f64 fd482, fd480, fd481;
mul.f64 fd483, fd477, fd424;
fma.rn.f64 fd484, fd479, fd386, fd483;
mul.f64 fd485, fd437, fd477;
mul.f64 fd486, fd438, fd479;
sub.f64 fd487, fd485, fd486;
mul.f64 fd488, fd437, fd479;
fma.rn.f64 fd489, fd438, fd477, fd488;
mul.f64 fd490, fd487, fd375;
mul.f64 fd491, fd489, fd413;
sub.f64 fd492, fd490, fd491;
mul.f64 fd493, fd487, fd413;
fma.rn.f64 fd494, fd489, fd375, fd493;
shl.b32 r24, r23, 3;
add.s32 r25, r8, r24;
barrier.sync 0;
mad.lo.s32 r26, r21, 2744, r25;
st.shared.f64 [r26], fd354;
st.shared.f64 [r26+392], fd443;
st.shared.f64 [r26+784], fd453;
st.shared.f64 [r26+1176], fd463;
st.shared.f64 [r26+1568], fd472;
st.shared.f64 [r26+1960], fd482;
st.shared.f64 [r26+2352], fd492;
barrier.sync 0;
ld.shared.f64 fd495, [r10];
ld.shared.f64 fd496, [r10+2744];
ld.shared.f64 fd497, [r10+5488];
ld.shared.f64 fd498, [r10+8232];
ld.shared.f64 fd499, [r10+10976];
ld.shared.f64 fd500, [r10+13720];
ld.shared.f64 fd501, [r10+16464];
barrier.sync 0;
st.shared.f64 [r26], fd360;
st.shared.f64 [r26+392], fd445;
st.shared.f64 [r26+784], fd455;
st.shared.f64 [r26+1176], fd465;
st.shared.f64 [r26+1568], fd474;
st.shared.f64 [r26+1960], fd484;
st.shared.f64 [r26+2352], fd494;
barrier.sync 0;
ld.shared.f64 fd502, [r10];
ld.shared.f64 fd503, [r10+2744];
ld.shared.f64 fd504, [r10+5488];
ld.shared.f64 fd505, [r10+8232];
ld.shared.f64 fd506, [r10+10976];
ld.shared.f64 fd507, [r10+13720];
ld.shared.f64 fd508, [r10+16464];
add.f64 fd509, fd496, fd501;
add.f64 fd510, fd495, fd509;
add.f64 fd511, fd497, fd500;
add.f64 fd512, fd511, fd510;
add.f64 fd513, fd498, fd499;
add.f64 fd514, fd503, fd508;
add.f64 fd515, fd502, fd514;
add.f64 fd516, fd504, fd507;
add.f64 fd517, fd516, fd515;
add.f64 fd518, fd505, fd506;
fma.rn.f64 fd519, fd509, 0d3FE3F3A0E28BEDD1, fd495;
mul.f64 fd520, fd511, 0d3FCC7B90E3024582;
sub.f64 fd521, fd519, fd520;
mul.f64 fd522, fd513, 0d3FECD4BCA9CB5C71;
sub.f64 fd523, fd521, fd522;
sub.f64 fd524, fd503, fd508;
mul.f64 fd525, fd524, 0d3FE904C37505DE4B;
sub.f64 fd526, fd504, fd507;
mul.f64 fd527, fd526, 0dBFEF329C0558E969;
sub.f64 fd528, fd527, fd525;
sub.f64 fd529, fd505, fd506;
mul.f64 fd530, fd529, 0d3FDBC4C04D71ABC1;
sub.f64 fd531, fd528, fd530;
mul.f64 fd532, fd509, 0d3FCC7B90E3024582;
sub.f64 fd533, fd495, fd532;
mul.f64 fd534, fd511, 0d3FECD4BCA9CB5C71;
sub.f64 fd535, fd533, fd534;
fma.rn.f64 fd536, fd513, 0d3FE3F3A0E28BEDD1, fd535;
mul.f64 fd537, fd524, 0d3FEF329C0558E969;
mul.f64 fd538, fd526, 0d3FDBC4C04D71ABC1;
sub.f64 fd539, fd538, fd537;
fma.rn.f64 fd540, fd529, 0d3FE904C37505DE4B, fd539;
mul.f64 fd541, fd509, 0d3FECD4BCA9CB5C71;
sub.f64 fd542, fd495, fd541;
fma.rn.f64 fd543, fd511, 0d3FE3F3A0E28BEDD1, fd542;
mul.f64 fd544, fd513, 0d3FCC7B90E3024582;
sub.f64 fd545, fd543, fd544;
mul.f64 fd546, fd524, 0d3FDBC4C04D71ABC1;
mul.f64 fd547, fd526, 0d3FE904C37505DE4B;
sub.f64 fd548, fd547, fd546;
mul.f64 fd549, fd529, 0d3FEF329C0558E969;
sub.f64 fd550, fd548, fd549;
fma.rn.f64 fd551, fd514, 0d3FE3F3A0E28BEDD1, fd502;
mul.f64 fd552, fd516, 0d3FCC7B90E3024582;
sub.f64 fd553, fd551, fd552;
mul.f64 fd554, fd518, 0d3FECD4BCA9CB5C71;
sub.f64 fd555, fd553, fd554;
sub.f64 fd556, fd496, fd501;
mul.f64 fd557, fd556, 0d3FE904C37505DE4B;
sub.f64 fd558, fd497, fd500;
mul.f64 fd559, fd558, 0dBFEF329C0558E969;
sub.f64 fd560, fd559, fd557;
sub.f64 fd561, fd498, fd499;
mul.f64 fd562, fd561, 0d3FDBC4C04D71ABC1;
sub.f64 fd563, fd560, fd562;
mul.f64 fd564, fd514, 0d3FCC7B90E3024582;
sub.f64 fd565, fd502, fd564;
mul.f64 fd566, fd516, 0d3FECD4BCA9CB5C71;
sub.f64 fd567, fd565, fd566;
fma.rn.f64 fd568, fd518, 0d3FE3F3A0E28BEDD1, fd567;
mul.f64 fd569, fd556, 0d3FEF329C0558E969;
mul.f64 fd570, fd558, 0d3FDBC4C04D71ABC1;
sub.f64 fd571, fd570, fd569;
fma.rn.f64 fd572, fd561, 0d3FE904C37505DE4B, fd571;
mul.f64 fd573, fd514, 0d3FECD4BCA9CB5C71;
sub.f64 fd574, fd502, fd573;
fma.rn.f64 fd575, fd516, 0d3FE3F3A0E28BEDD1, fd574;
mul.f64 fd576, fd518, 0d3FCC7B90E3024582;
sub.f64 fd577, fd575, fd576;
mul.f64 fd578, fd556, 0d3FDBC4C04D71ABC1;
mul.f64 fd579, fd558, 0d3FE904C37505DE4B;
sub.f64 fd580, fd579, fd578;
mul.f64 fd581, fd561, 0d3FEF329C0558E969;
sub.f64 fd582, fd580, fd581;
add.f64 %0, fd513, fd512;
add.f64 %1, fd518, fd517;
add.f64 %3, fd563, fd555;
sub.f64 %2, fd523, fd531;
sub.f64 %4, fd536, fd540;
add.f64 %5, fd572, fd568;
sub.f64 %6, fd545, fd550;
add.f64 %7, fd582, fd577;
add.f64 %8, fd550, fd545;
sub.f64 %9, fd577, fd582;
add.f64 %10, fd540, fd536;
sub.f64 %11, fd568, fd572;
sub.f64 %13, fd555, fd563;
add.f64 %12, fd531, fd523;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y): "r"(smem), "l"(lut_dp_7_2401), "l"(lut_dp_7_343), "l"(lut_dp_7_49), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y));
};


#endif
